/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.descriptorparser.builders;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.BridgeServerDescriptor;
import org.torproject.descriptor.RelayServerDescriptor;
import org.torproject.descriptor.ServerDescriptor;
import org.torproject.metrics.descriptorparser.utils.DescriptorUtils;
import org.torproject.metrics.descriptorparser.utils.LookupResult;
import org.torproject.metrics.descriptorparser.utils.LookupService;
import org.torproject.metrics.descriptorparser.utils.ReverseDomainNameResolver;
import org.torproject.metrics.descriptorparser.utils.TorVersion;
import org.torproject.metrics.descriptorparser.utils.TorVersionStatus;

public class RouterStatusBuilder {
    private static final Logger logger = LoggerFactory.getLogger(RouterStatusBuilder.class);
    private static final String INSERT_ROUTER_STATUS_SQL = "INSERT INTO server_status (is_bridge, published, nickname, fingerprint, or_addresses, last_seen, first_seen, running, flags, country, country_name, autonomous_system, as_name, verified_host_names, last_restarted, exit_policy, contacts, platform, version, version_status, effective_family, declared_family, transport, bridgedb_distributor, blocklist, last_changed_address_or_port, diff_or_addresses, unverified_host_names, unreachable_or_addresses) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ON CONFLICT DO NOTHING;";
    private static final String SELECT_LAST_ROUTER_STATUS_SQL = "SELECT * FROM server_status WHERE fingerprint=? AND nickname=? AND published<=? ORDER BY published DESC LIMIT 1;";
    private static final String SELECT_FIRST_NETWORK_STATUS_SQL = "SELECT * FROM network_status_entry WHERE fingerprint=? AND nickname=? AND time<=? ORDER BY time ASC LIMIT 1;";
    private static final String SELECT_LAST_NETWORK_STATUS_SQL = "SELECT * FROM network_status_entry WHERE fingerprint=? AND nickname=? AND time<=? ORDER BY time DESC LIMIT 1;";
    private static final String SELECT_FIRST_BRIDGE_STATUS_SQL = "SELECT * FROM bridge_status WHERE fingerprint=? AND nickname=? AND published<=? ORDER BY published ASC LIMIT 1;";
    private static final String SELECT_LAST_BRIDGE_STATUS_SQL = "SELECT * FROM bridge_status WHERE fingerprint=? AND nickname=? and published<=? ORDER BY published DESC LIMIT 1;";
    private static final String SELECT_LAST_BRIDGESTRAP_TEST_SQL = "SELECT * FROM bridgestrap_test WHERE fingerprint=? AND published<=? ORDER BY published DESC LIMIT 1;";
    private static final String SELECT_LAST_BRIDGE_POOL_SQL = "SELECT * FROM bridge_pool_assignment WHERE fingerprint=? AND published<=? ORDER BY published DESC LIMIT 1;";
    private static final String SELECT_NETWORK_STATUS_SQL = "SELECT * FROM network_status WHERE digest=?;";
    private static final String SELECT_LAST_NETWORK_STATUS_TIME_SQL = "SELECT * FROM network_status WHERE valid_after<=? ORDER BY valid_after DESC LIMIT 1;";
    private static final String SELECT_FAMILY_MEMBERS = "SELECT * FROM server_status WHERE fingerprint=? ORDER BY published DESC LIMIT 1;";
    private static boolean isBridge = false;
    private ReverseDomainNameResolver reverseDomainNameResolver;
    private LookupService lookupService;
    private DescriptorUtils descUtils = new DescriptorUtils();
    private long now;
    private long firstSeenMillis = 0L;
    private long lastSeenMillis = 0L;
    private String orAddresses = "";
    private long lastChangedAddressesMillis = -1L;
    private String diffOrAddresses = null;
    private String orAddressesAndPorts = null;
    private String version = null;
    private String[] recommendedVersions = null;
    private String networkStatus = null;
    private String transports = "";
    private String distributionMethod = "";
    private String blocklist = "";
    private long bridgestrapLastEndMillis = -1L;
    private String flags = "";
    private SortedMap<String, Integer> lastBandwidthWeights = null;
    private SortedSet<TorVersion> lastRecommendedServerVersions = null;
    private SortedSet<String> declaredFamily = new TreeSet<String>();
    private SortedSet<String> effectiveFamily = new TreeSet<String>();

    public void build(ServerDescriptor desc, Connection conn) throws Exception {
        String versions;
        ResultSet rs;
        PreparedStatement preparedQueryStatement;
        block58: {
            String selectLastStatus = "";
            String selectFirstStatus = "";
            this.now = System.currentTimeMillis();
            this.reverseDomainNameResolver = new ReverseDomainNameResolver();
            this.lookupService = new LookupService(new File("geoip"));
            if (desc instanceof RelayServerDescriptor) {
                desc = (RelayServerDescriptor)desc;
                isBridge = false;
                selectLastStatus = SELECT_LAST_NETWORK_STATUS_SQL;
                selectFirstStatus = SELECT_FIRST_NETWORK_STATUS_SQL;
                this.effectiveFamily.add(desc.getFingerprint());
                if (desc.getFamilyEntries() != null) {
                    for (String familyMember : desc.getFamilyEntries()) {
                        if (familyMember.startsWith("$") && familyMember.length() == 41) {
                            familyMember = familyMember.substring(1, 41).toUpperCase();
                        }
                        this.declaredFamily.add(familyMember);
                        PreparedStatement preparedFamilyQuerySt = conn.prepareStatement(SELECT_FAMILY_MEMBERS);
                        preparedFamilyQuerySt.clearParameters();
                        preparedFamilyQuerySt.setString(1, familyMember);
                        try {
                            String declaredFam;
                            ResultSet rs2 = preparedFamilyQuerySt.executeQuery();
                            if (!rs2.next()) continue;
                            String member = rs2.getString("fingerprint");
                            if (member.startsWith("$") && member.length() == 41) {
                                member = member.substring(1, 41).toUpperCase();
                            }
                            if (!(declaredFam = rs2.getString("declared_family")).contains(desc.getFingerprint())) continue;
                            this.effectiveFamily.add(member);
                        }
                        catch (SQLException ex) {
                            logger.warn(String.format(ex.getMessage(), new Object[0]));
                        }
                    }
                }
                this.declaredFamily.add(desc.getFingerprint());
            } else {
                desc = (BridgeServerDescriptor)desc;
                selectLastStatus = SELECT_LAST_BRIDGE_STATUS_SQL;
                selectFirstStatus = SELECT_FIRST_BRIDGE_STATUS_SQL;
                isBridge = true;
            }
            preparedQueryStatement = conn.prepareStatement(SELECT_LAST_ROUTER_STATUS_SQL);
            preparedQueryStatement.clearParameters();
            preparedQueryStatement.setString(1, desc.getFingerprint());
            preparedQueryStatement.setString(2, desc.getNickname());
            preparedQueryStatement.setTimestamp(3, new Timestamp(desc.getPublishedMillis()));
            try {
                rs = preparedQueryStatement.executeQuery();
                if (rs.next()) {
                    this.firstSeenMillis = rs.getTimestamp("first_seen").getTime();
                    this.orAddresses = rs.getString("or_addresses");
                    this.lastChangedAddressesMillis = rs.getTimestamp("last_changed_address_or_port").getTime();
                    this.diffOrAddresses = rs.getString("diff_or_addresses");
                    preparedQueryStatement = conn.prepareStatement(selectLastStatus);
                    preparedQueryStatement.clearParameters();
                    preparedQueryStatement.setString(1, desc.getFingerprint());
                    preparedQueryStatement.setString(2, desc.getNickname());
                    preparedQueryStatement.setTimestamp(3, new Timestamp(desc.getPublishedMillis()));
                    rs = preparedQueryStatement.executeQuery();
                    if (rs.next()) {
                        this.flags = rs.getString("flags");
                        if (isBridge) {
                            this.lastSeenMillis = rs.getTimestamp("published").getTime();
                            this.version = this.getBridgeServerVersion(desc);
                        } else {
                            this.lastSeenMillis = rs.getTimestamp("time").getTime();
                            this.version = rs.getString("version");
                            this.orAddressesAndPorts = rs.getString("or_addresses") + "," + rs.getString("or_port");
                        }
                        this.networkStatus = rs.getString("network_status");
                    }
                    break block58;
                }
                preparedQueryStatement = conn.prepareStatement(selectFirstStatus);
                preparedQueryStatement.clearParameters();
                preparedQueryStatement.setString(1, desc.getFingerprint());
                preparedQueryStatement.setString(2, desc.getNickname());
                preparedQueryStatement.setTimestamp(3, new Timestamp(desc.getPublishedMillis()));
                rs = preparedQueryStatement.executeQuery();
                if (rs.next()) {
                    if (isBridge) {
                        this.firstSeenMillis = rs.getTimestamp("published").getTime();
                        this.version = this.getBridgeServerVersion(desc);
                    } else {
                        this.firstSeenMillis = rs.getTimestamp("time").getTime();
                        this.version = rs.getString("version");
                        this.orAddressesAndPorts = rs.getString("or_addresses") + "," + rs.getString("or_port");
                    }
                    this.lastSeenMillis = this.firstSeenMillis;
                    break block58;
                }
                return;
            }
            catch (SQLException ex) {
                logger.warn(String.format(ex.getMessage(), new Object[0]));
            }
        }
        if (desc instanceof RelayServerDescriptor && this.networkStatus != null) {
            try {
                preparedQueryStatement = conn.prepareStatement(SELECT_NETWORK_STATUS_SQL);
                preparedQueryStatement.clearParameters();
                preparedQueryStatement.setString(1, this.networkStatus);
                rs = preparedQueryStatement.executeQuery();
                if (rs.next()) {
                    versions = rs.getString("recommended_server_version");
                    this.recommendedVersions = this.getRecommendedVersions(versions);
                }
            }
            catch (SQLException ex) {
                logger.warn(String.format(ex.getMessage(), new Object[0]));
            }
        } else {
            try {
                preparedQueryStatement = conn.prepareStatement(SELECT_LAST_NETWORK_STATUS_TIME_SQL);
                preparedQueryStatement.clearParameters();
                preparedQueryStatement.setTimestamp(1, new Timestamp(desc.getPublishedMillis()));
                rs = preparedQueryStatement.executeQuery();
                if (rs.next()) {
                    versions = rs.getString("recommended_server_version");
                    this.recommendedVersions = this.getRecommendedVersions(versions);
                }
            }
            catch (SQLException ex) {
                logger.warn(String.format(ex.getMessage(), new Object[0]));
            }
        }
        boolean running = true;
        if (!isBridge && this.lastSeenMillis >= this.now - 604800000L) {
            running = false;
        } else if (isBridge) {
            ResultSet rs3;
            try {
                preparedQueryStatement = conn.prepareStatement(SELECT_LAST_BRIDGESTRAP_TEST_SQL);
                preparedQueryStatement.clearParameters();
                preparedQueryStatement.setString(1, desc.getFingerprint());
                preparedQueryStatement.setTimestamp(2, new Timestamp(desc.getPublishedMillis()));
                rs3 = preparedQueryStatement.executeQuery();
                if (rs3.next()) {
                    boolean result = rs3.getBoolean("result");
                    long bridgestrapLastEndMillis = rs3.getTimestamp("published").getTime();
                    if (!result) {
                        running = false;
                    } else if (bridgestrapLastEndMillis >= this.now - 604800000L) {
                        running = false;
                    }
                } else {
                    running = false;
                }
            }
            catch (SQLException ex) {
                logger.warn(String.format(ex.getMessage(), new Object[0]));
            }
            try {
                preparedQueryStatement = conn.prepareStatement(SELECT_LAST_BRIDGE_POOL_SQL);
                preparedQueryStatement.clearParameters();
                preparedQueryStatement.setString(1, desc.getFingerprint());
                preparedQueryStatement.setTimestamp(2, new Timestamp(desc.getPublishedMillis()));
                rs3 = preparedQueryStatement.executeQuery();
                if (rs3.next()) {
                    this.transports = rs3.getString("transports");
                    this.distributionMethod = rs3.getString("distribution_method");
                    this.blocklist = rs3.getString("blocklist");
                }
            }
            catch (SQLException ex) {
                logger.warn(String.format(ex.getMessage(), new Object[0]));
            }
        }
        TreeSet<String> addressStrings = new TreeSet<String>();
        addressStrings.add(desc.getAddress());
        SortedMap<String, LookupResult> lookupResults = this.lookupService.lookup(addressStrings);
        LookupResult lookupResult = (LookupResult)lookupResults.get(desc.getAddress());
        HashMap<String, Long> addressLastLookupTimes = new HashMap<String, Long>();
        addressLastLookupTimes.put(desc.getAddress(), this.lastSeenMillis);
        this.reverseDomainNameResolver.setAddresses(addressLastLookupTimes);
        this.reverseDomainNameResolver.startReverseDomainNameLookups();
        Map<String, SortedSet<String>> verifiedLookupResults = this.reverseDomainNameResolver.getVerifiedLookupResults();
        Map<String, SortedSet<String>> unverifiedLookupResults = this.reverseDomainNameResolver.getUnverifiedLookupResults();
        String descOrAddress = this.descUtils.fieldAsString(desc.getOrAddresses());
        if (!isBridge && descOrAddress != this.orAddresses) {
            this.lastChangedAddressesMillis = desc.getPublishedMillis();
            this.diffOrAddresses = StringUtils.difference(this.orAddresses, descOrAddress);
        }
        SortedSet<String> verifiedHostNames = verifiedLookupResults.get(desc.getAddress());
        SortedSet<String> unverifiedHostNames = unverifiedLookupResults.get(desc.getAddress());
        try (PreparedStatement preparedStatement = conn.prepareStatement(INSERT_ROUTER_STATUS_SQL);){
            preparedStatement.setBoolean(1, isBridge);
            preparedStatement.setTimestamp(2, new Timestamp(desc.getPublishedMillis()));
            preparedStatement.setString(3, desc.getNickname());
            preparedStatement.setString(4, desc.getFingerprint());
            preparedStatement.setString(5, desc.getOrAddresses().toString());
            preparedStatement.setTimestamp(6, new Timestamp(this.lastSeenMillis));
            preparedStatement.setTimestamp(7, new Timestamp(this.firstSeenMillis));
            preparedStatement.setBoolean(8, running);
            preparedStatement.setString(9, this.flags);
            if (lookupResult != null) {
                preparedStatement.setString(10, lookupResult.getCountryCode());
                preparedStatement.setString(11, lookupResult.getCountryName());
                preparedStatement.setString(12, lookupResult.getAsNumber());
                preparedStatement.setString(13, lookupResult.getAsName());
            } else {
                preparedStatement.setString(10, "");
                preparedStatement.setString(11, "");
                preparedStatement.setString(12, "");
                preparedStatement.setString(13, "");
            }
            preparedStatement.setString(14, this.descUtils.fieldAsString(verifiedHostNames));
            preparedStatement.setTimestamp(15, new Timestamp(this.calculateLastRestartedMillis(desc)));
            preparedStatement.setString(16, this.descUtils.fieldAsString(desc.getExitPolicyLines()));
            if (desc.getContact() != null) {
                preparedStatement.setString(17, desc.getContact());
            } else {
                preparedStatement.setString(17, "");
            }
            preparedStatement.setString(18, desc.getPlatform());
            if (this.version != null) {
                preparedStatement.setString(19, this.version);
                preparedStatement.setString(20, this.getVersionStatus());
            } else {
                preparedStatement.setString(19, "");
                preparedStatement.setString(20, "");
            }
            if (desc.getFamilyEntries() != null) {
                preparedStatement.setString(21, this.descUtils.fieldAsString(this.effectiveFamily));
                preparedStatement.setString(22, this.descUtils.fieldAsString(desc.getFamilyEntries()));
            } else {
                preparedStatement.setString(21, desc.getFingerprint());
                preparedStatement.setString(22, desc.getFingerprint());
            }
            preparedStatement.setString(23, this.transports);
            preparedStatement.setString(24, this.distributionMethod);
            preparedStatement.setString(25, this.blocklist);
            preparedStatement.setTimestamp(26, new Timestamp(this.lastChangedAddressesMillis));
            preparedStatement.setString(27, this.diffOrAddresses);
            preparedStatement.setString(28, this.descUtils.fieldAsString(unverifiedHostNames));
            if (this.orAddressesAndPorts == null) {
                preparedStatement.setString(29, this.descUtils.fieldAsString(desc.getOrAddresses()));
            } else {
                String unreachable = desc.getOrAddresses().toString();
                for (String address : this.orAddressesAndPorts.split(",")) {
                    unreachable = unreachable.replace(address, "");
                }
                preparedStatement.setString(29, unreachable);
            }
            preparedStatement.executeUpdate();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.warn(String.format(ex.getMessage(), new Object[0]));
        }
    }

    private String getBridgeServerVersion(ServerDescriptor desc) {
        if (desc.getPlatform() != null) {
            String[] platformParts = desc.getPlatform().split(" on ");
            return platformParts[0].toLowerCase();
        }
        return null;
    }

    private String[] getRecommendedVersions(String versions) {
        if (versions != null) {
            return versions.split(" ")[1].split(",");
        }
        return null;
    }

    private Long calculateLastRestartedMillis(ServerDescriptor descriptor) {
        Long lastRestartedMillis = 0L;
        if (null != descriptor.getUptime()) {
            lastRestartedMillis = descriptor.getPublishedMillis() - descriptor.getUptime() * 1000L;
        }
        return lastRestartedMillis;
    }

    private String getVersionStatus() {
        String stringTorVersion = null;
        if (this.version != null && this.version.startsWith("Tor ")) {
            stringTorVersion = this.version.split(" ")[1];
        }
        TorVersion torVersion = TorVersion.of(stringTorVersion);
        String versionStatus = "";
        TreeSet<TorVersion> lastRecommendedServerVersions = new TreeSet<TorVersion>();
        if (this.recommendedVersions != null) {
            for (String recommendedServerVersion : this.recommendedVersions) {
                TorVersion recommendedTorServerVersion = TorVersion.of(recommendedServerVersion);
                if (null == recommendedTorServerVersion) continue;
                lastRecommendedServerVersions.add(recommendedTorServerVersion);
            }
        }
        versionStatus = (null != torVersion ? torVersion.determineVersionStatus(lastRecommendedServerVersions) : TorVersionStatus.UNRECOMMENDED).toString();
        return versionStatus;
    }
}

