// -*- mode: C++ -*-

/* This file is auto-generated by run_glean_parser.py.
   It is only for internal use by types in
   toolkit/components/glean/bindings/private */

#include "mozilla/AppShutdown.h"
#include "mozilla/ClearOnShutdown.h"
#include "mozilla/glean/bindings/GleanJSMetricsLookup.h"
#include "mozilla/glean/bindings/jog/JOG.h"
#include "mozilla/Maybe.h"
#include "mozilla/Telemetry.h"
#include <tuple>
#include "mozilla/DataMutex.h"
#include "nsIThread.h"
#include "nsThreadUtils.h"

#ifndef mozilla_glean_HistogramGifftMap_h
#define mozilla_glean_HistogramGifftMap_h

#define DYNAMIC_METRIC_BIT (26)
#define GLEAN_METRIC_ID(id) ((id) & ((1ULL << 27) - 1))

namespace mozilla::glean {

using Telemetry::HistogramID;


using MetricId = uint32_t; // Same type as in api/src/private/mod.rs
using TimerId = uint64_t; // Same as in TimingDistribution.h.
struct MetricTimerTuple {
  MetricId mMetricId;
  TimerId mTimerId;
};
class MetricTimerTupleHashKey : public PLDHashEntryHdr {
 public:
  using KeyType = const MetricTimerTuple&;
  using KeyTypePointer = const MetricTimerTuple*;

  explicit MetricTimerTupleHashKey(KeyTypePointer aKey) : mValue(*aKey) {}
  MetricTimerTupleHashKey(MetricTimerTupleHashKey&& aOther)
      : PLDHashEntryHdr(std::move(aOther)),
        mValue(std::move(aOther.mValue)) {}
  ~MetricTimerTupleHashKey() = default;

  KeyType GetKey() const { return mValue; }
  bool KeyEquals(KeyTypePointer aKey) const {
    return aKey->mMetricId == mValue.mMetricId &&
           aKey->mTimerId == mValue.mTimerId;
  }

  static KeyTypePointer KeyToPointer(KeyType aKey) { return &aKey; }
  static PLDHashNumber HashKey(KeyTypePointer aKey) {
    // Chosen because this is how nsIntegralHashKey does it.
    return HashGeneric(aKey->mMetricId, aKey->mTimerId);
  }
  enum { ALLOW_MEMMOVE = true };
  static_assert(std::is_trivially_copyable_v<MetricTimerTuple>);

 private:
  const MetricTimerTuple mValue;
};

typedef StaticDataMutex<UniquePtr<nsTHashMap<MetricTimerTupleHashKey, TimeStamp>>> TimerToStampMutex;
static inline Maybe<TimerToStampMutex::AutoLock> GetTimerIdToStartsLock() {
  static TimerToStampMutex sTimerIdToStarts("sTimerIdToStarts");
  auto lock = sTimerIdToStarts.Lock();
  // GIFFT will work up to the end of AppShutdownTelemetry.
  if (AppShutdown::IsInOrBeyond(ShutdownPhase::XPCOMWillShutdown)) {
    return Nothing();
  }
  if (!*lock) {
    *lock = MakeUnique<nsTHashMap<MetricTimerTupleHashKey, TimeStamp>>();
    RefPtr<nsIRunnable> cleanupFn = NS_NewRunnableFunction(__func__, [&] {
      if (AppShutdown::IsInOrBeyond(ShutdownPhase::XPCOMWillShutdown)) {
        auto lock = sTimerIdToStarts.Lock();
        *lock = nullptr;  // deletes, see UniquePtr.h
        return;
      }
      RunOnShutdown([&] {
        auto lock = sTimerIdToStarts.Lock();
        *lock = nullptr;  // deletes, see UniquePtr.h
      }, ShutdownPhase::XPCOMWillShutdown);
    });
    // Both getting the main thread and dispatching to it can fail.
    // In that event we leak. Grab a pointer so we have something to NS_RELEASE
    // in that case.
    nsIRunnable* temp = cleanupFn.get();
    nsCOMPtr<nsIThread> mainThread;
    if (NS_FAILED(NS_GetMainThread(getter_AddRefs(mainThread)))
      || NS_FAILED(mainThread->Dispatch(cleanupFn.forget(), nsIThread::DISPATCH_NORMAL))
    ) {
      // Failed to dispatch cleanup routine.
      // First, un-leak the runnable (but only if we actually attempted dispatch)
      if (!cleanupFn) {
        NS_RELEASE(temp);
      }
      // Next, cleanup immediately, and allow metrics to try again later.
      *lock = nullptr;
      return Nothing();
    }
  }
  return Some(std::move(lock));
}

static Maybe<HistogramID> HistogramIdForMetric(uint32_t aId) {
  switch(aId) {
    case 110: { // paint.build_displaylist_time
      return Some(HistogramID::PAINT_BUILD_DISPLAYLIST_TIME);
    }
    case 111: { // wr.framebuild_time
      return Some(HistogramID::WR_FRAMEBUILD_TIME);
    }
    case 112: { // wr.gpu_wait_time
      return Some(HistogramID::WR_GPU_WAIT_TIME);
    }
    case 113: { // wr.rasterize_blobs_time
      return Some(HistogramID::WR_RASTERIZE_BLOBS_TIME);
    }
    case 114: { // wr.rasterize_glyphs_time
      return Some(HistogramID::WR_RASTERIZE_GLYPHS_TIME);
    }
    case 115: { // wr.renderer_time
      return Some(HistogramID::WR_RENDERER_TIME);
    }
    case 116: { // wr.renderer_time_no_sc
      return Some(HistogramID::WR_RENDERER_TIME_NO_SC_MS);
    }
    case 117: { // wr.scenebuild_time
      return Some(HistogramID::WR_SCENEBUILD_TIME);
    }
    case 118: { // wr.sceneswap_time
      return Some(HistogramID::WR_SCENESWAP_TIME);
    }
    case 119: { // wr.texture_cache_update_time
      return Some(HistogramID::WR_TEXTURE_CACHE_UPDATE_TIME);
    }
    case 120: { // wr.time_to_frame_build
      return Some(HistogramID::WR_TIME_TO_FRAME_BUILD_MS);
    }
    case 121: { // wr.time_to_render_start
      return Some(HistogramID::WR_TIME_TO_RENDER_START_MS);
    }
    case 164: { // cookie.banners.click.handle_duration
      return Some(HistogramID::COOKIE_BANNERS_CLICK_HANDLE_DURATION_MS);
    }
    case 172: { // extensions.apis.dnr.evaluate_rules_time
      return Some(HistogramID::WEBEXT_DNR_EVALUATE_RULES_MS);
    }
    case 174: { // extensions.apis.dnr.startup_cache_read_size
      return Some(HistogramID::WEBEXT_DNR_STARTUPCACHE_READ_BYTES);
    }
    case 175: { // extensions.apis.dnr.startup_cache_read_time
      return Some(HistogramID::WEBEXT_DNR_STARTUPCACHE_READ_MS);
    }
    case 176: { // extensions.apis.dnr.startup_cache_write_size
      return Some(HistogramID::WEBEXT_DNR_STARTUPCACHE_WRITE_BYTES);
    }
    case 177: { // extensions.apis.dnr.startup_cache_write_time
      return Some(HistogramID::WEBEXT_DNR_STARTUPCACHE_WRITE_MS);
    }
    case 178: { // extensions.apis.dnr.validate_rules_time
      return Some(HistogramID::WEBEXT_DNR_VALIDATE_RULES_MS);
    }
    case 207: { // test_only.what_time_is_it
      return Some(HistogramID::TELEMETRY_TEST_MIRROR_FOR_TIMING);
    }
    case 210: { // test_only.ipc.a_custom_dist
      return Some(HistogramID::TELEMETRY_TEST_MIRROR_FOR_CUSTOM);
    }
    case 213: { // test_only.ipc.a_memory_dist
      return Some(HistogramID::TELEMETRY_TEST_LINEAR);
    }
    case 218: { // test_only.ipc.a_timing_dist
      return Some(HistogramID::TELEMETRY_TEST_EXPONENTIAL);
    }
    case 273: { // search.service.startup_time
      return Some(HistogramID::SEARCH_SERVICE_INIT2_MS);
    }
    default: {
      if (MOZ_UNLIKELY(aId & (1 << DYNAMIC_METRIC_BIT))) {
        // Dynamic (runtime-registered) metric. Use its static (compiletime-
        // registered) metric's telemetry_mirror mapping.
        // ...if applicable.

        // Only JS can use dynamic (runtime-registered) metric ids.
        MOZ_ASSERT(NS_IsMainThread());

        auto metricName = JOG::GetMetricName(aId);
        // All of these should have names, but the storage only lasts until
        // XPCOMWillShutdown, so it might return `Nothing()`.
        if (metricName.isSome()) {
          auto maybeMetric = MetricByNameLookup(metricName.ref());
          if (maybeMetric.isSome()) {
            uint32_t staticId = GLEAN_METRIC_ID(maybeMetric.value());
            // Let's ensure we don't infinite loop, huh.
            MOZ_ASSERT(!(staticId & (1 << DYNAMIC_METRIC_BIT)));
            return HistogramIdForMetric(staticId);
          }
        }
      }
      return Nothing();
    }
  }
}

}  // namespace mozilla::glean

#undef GLEAN_METRIC_ID
#undef DYNAMIC_METRIC_BIT

#endif  // mozilla_glean_HistogramGifftMaps_h
