/* THIS FILE IS AUTOGENERATED FROM AddonManager.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_AddonManagerBinding_h
#define mozilla_dom_AddonManagerBinding_h

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/DOMEventTargetHelper.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackInterface.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/ToJSValue.h"
#include "nsWeakReference.h"

namespace mozilla {
namespace dom {

class Addon;
struct AddonAtoms;
class AddonInstall;
struct AddonInstallAtoms;
class AddonManager;
struct AddonManagerAtoms;
class AddonManagerPermissions;
struct NativePropertyHooks;
class Promise;
class ProtoAndIfaceCache;
struct addonInstallOptions;
struct addonInstallOptionsAtoms;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

struct addonInstallOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mHash;
  MOZ_INIT_OUTSIDE_CTOR nsString mUrl;

  addonInstallOptions();

  explicit inline addonInstallOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  addonInstallOptions(addonInstallOptions&& aOther) = default;

  explicit inline addonInstallOptions(const addonInstallOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  addonInstallOptions&
  operator=(const addonInstallOptions& aOther);

  bool
  operator==(const addonInstallOptions& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, addonInstallOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastaddonInstallOptions : public addonInstallOptions
{
  inline FastaddonInstallOptions()
    : addonInstallOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace Addon_Binding {

  typedef mozilla::dom::Addon NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::Addon* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::Addon,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::Addon,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::Addon,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace Addon_Binding



namespace AddonInstall_Binding {

  typedef mozilla::dom::AddonInstall NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::AddonInstall* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::AddonInstall,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::AddonInstall,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::AddonInstall,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace AddonInstall_Binding



namespace AddonManager_Binding {

  typedef mozilla::dom::AddonManager NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::AddonManager* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::AddonManager,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::AddonManager,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::AddonManager,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace AddonManager_Binding



namespace AddonManagerPermissions_Binding {

  typedef mozilla::dom::AddonManagerPermissions NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::AddonManagerPermissions,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::AddonManagerPermissions,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace AddonManagerPermissions_Binding



class AddonJSImpl : public CallbackInterface
{
public:
  explicit inline AddonJSImpl(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
  }

  explicit inline AddonJSImpl(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackInterface(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  explicit inline AddonJSImpl(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
  }

  already_AddRefed<Promise> Uninstall(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<Promise> SetEnabled(bool value, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  inline bool
  operator==(const AddonJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

  void GetId(nsString& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void GetVersion(nsString& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void GetType(nsString& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void GetName(nsString& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void GetDescription(nsString& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  bool GetIsEnabled(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  bool GetIsActive(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  bool GetCanUninstall(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

private:
  static bool
  InitIds(JSContext* cx, AddonAtoms* atomsCache);
};


class Addon final : public nsSupportsWeakReference,
                    public nsWrapperCache
{
public:
  NS_DECL_CYCLE_COLLECTING_ISUPPORTS
  NS_DECL_CYCLE_COLLECTION_WRAPPERCACHE_CLASS(Addon)

private:
  RefPtr<AddonJSImpl> mImpl;
  nsCOMPtr<nsIGlobalObject> mParent;

public:
  Addon(JS::Handle<JSObject*> aJSImplObject, JS::Handle<JSObject*> aJSImplGlobal, nsIGlobalObject* aParent);

private:
  ~Addon();

public:
  nsISupports* GetParentObject() const;

  JSObject* WrapObject(JSContext* aCx, JS::Handle<JSObject*> aGivenProto) override;

  void GetId(nsString& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  void GetVersion(nsString& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  void GetType(nsString& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  void GetName(nsString& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  void GetDescription(nsString& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  bool GetIsEnabled(ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  bool GetIsActive(ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  bool GetCanUninstall(ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> Uninstall(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> SetEnabled(bool value, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


class AddonInstallJSImpl : public CallbackInterface
{
public:
  explicit inline AddonInstallJSImpl(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
  }

  explicit inline AddonInstallJSImpl(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackInterface(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  explicit inline AddonInstallJSImpl(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
  }

  already_AddRefed<Promise> Install(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<Promise> Cancel(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  inline bool
  operator==(const AddonInstallJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

  void GetState(nsString& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void GetError(nsString& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  int64_t GetProgress(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  int64_t GetMaxProgress(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

private:
  static bool
  InitIds(JSContext* cx, AddonInstallAtoms* atomsCache);
};


class AddonInstall final : public mozilla::DOMEventTargetHelper
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_CLASS_INHERITED(AddonInstall, mozilla::DOMEventTargetHelper)

private:
  RefPtr<AddonInstallJSImpl> mImpl;
  nsCOMPtr<nsIGlobalObject> mParent;

public:
  AddonInstall(JS::Handle<JSObject*> aJSImplObject, JS::Handle<JSObject*> aJSImplGlobal, nsIGlobalObject* aParent);

private:
  ~AddonInstall();

public:
  nsISupports* GetParentObject() const;

  JSObject* WrapObject(JSContext* aCx, JS::Handle<JSObject*> aGivenProto) override;

  void GetState(nsString& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  void GetError(nsString& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  int64_t GetProgress(ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  int64_t GetMaxProgress(ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> Install(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> Cancel(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


class AddonManagerJSImpl : public CallbackInterface
{
public:
  explicit inline AddonManagerJSImpl(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
  }

  explicit inline AddonManagerJSImpl(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackInterface(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  explicit inline AddonManagerJSImpl(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
  }

  already_AddRefed<Promise> GetAddonByID(const nsAString& id, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<Promise> CreateInstall(const addonInstallOptions& options, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  already_AddRefed<Promise> ReportAbuse(const nsAString& id, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void EventListenerAdded(const nsAString& aType, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr);

  void EventListenerRemoved(const nsAString& aType, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr);

  inline bool
  operator==(const AddonManagerJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

  bool GetAbuseReportPanelEnabled(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

private:
  static bool
  InitIds(JSContext* cx, AddonManagerAtoms* atomsCache);
};


class AddonManager final : public mozilla::DOMEventTargetHelper
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_CLASS_INHERITED(AddonManager, mozilla::DOMEventTargetHelper)

private:
  RefPtr<AddonManagerJSImpl> mImpl;
  nsCOMPtr<nsIGlobalObject> mParent;

public:
  AddonManager(JS::Handle<JSObject*> aJSImplObject, JS::Handle<JSObject*> aJSImplGlobal, nsIGlobalObject* aParent);

private:
  ~AddonManager();

public:
  nsISupports* GetParentObject() const;

  JSObject* WrapObject(JSContext* aCx, JS::Handle<JSObject*> aGivenProto) override;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> GetAddonByID(const nsAString& id, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> CreateInstall(const addonInstallOptions& options, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> ReportAbuse(const nsAString& id, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  bool GetAbuseReportPanelEnabled(ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  void
  EventListenerAdded(nsAtom* aType) override;

  using mozilla::DOMEventTargetHelper::EventListenerAdded;

  void
  EventListenerRemoved(nsAtom* aType) override;

  using mozilla::DOMEventTargetHelper::EventListenerRemoved;

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


} // namespace mozilla::dom

#endif // mozilla_dom_AddonManagerBinding_h
